% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adwords.R
\name{ga_adwords_delete_linkid}
\alias{ga_adwords_delete_linkid}
\title{Deletes a Google Analytics webProperty-Google Ads link}
\usage{
ga_adwords_delete_linkid(accountId, webPropertyId, webPropertyAdWordsLinkId)
}
\arguments{
\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id}

\item{webPropertyAdWordsLinkId}{webPropertyAdWordsLinkId}
}
\value{
HTTP Status Code 204 with empty response body, if successful
}
\description{
Removes a link between and Adwords (Google ads) account and a Google Analytics property
}
\examples{

\dontrun{

library(googleAnalyticsR)
ga_auth()

# get the ID of the Adwords- Google Analytics link that you want to delete 
# ID corresponding to the webPropertyAdWordsLinkId field
ga_adwords_list(65973592, "UA-65973592-1") 
 
ga_adwords_delete_linkid(65973592, "UA-65973592-1", "ezW2dyaiQcGheWRAo69nCw")


# check its gone
ga_adwords_list(65973592, "UA-65973592-1")
}

}
\seealso{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/webPropertyAdWordsLinks/delete}{Google documentation}

Other Google Ad management functions: 
\code{\link{ga_adwords}()},
\code{\link{ga_adwords_add_linkid}()},
\code{\link{ga_adwords_list}()}
}
\concept{Google Ad management functions}
