% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-cached-db.R
\name{gisco_get_cached_db}
\alias{gisco_get_cached_db}
\title{Retrieve and update the GISCO database in use by \CRANpkg{giscoR}}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}.
}
\usage{
gisco_get_cached_db(update_cache = FALSE)
}
\arguments{
\item{update_cache}{logical. On \code{TRUE} the cached database would be rebuilt
with the most updated information of the GISCO API.}
}
\value{
A \link[tibble:tbl_df-class]{tibble}.
}
\description{
Returns or optionally updates the cached database with the endpoints of the
GISCO API.
}
\details{
The cached database is stored in the \CRANpkg{giscoR} cache path, see
\code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}} for details. The cached database would be used
in subsequent \strong{R} sessions.

On new GISCO data releases, you can access the new updated data simply by
refreshing the cached database without waiting for a new version of
\CRANpkg{giscoR}.

A static database \link{gisco_db} is shipped with the package. This database would
be used in case there is any problem on update.
}
\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}

gisco_get_cached_db() |>
  dplyr::glimpse()
\dontshow{\}) # examplesIf}
}
\seealso{
Other database utils:
\code{\link{gisco_db}},
\code{\link{gisco_get_metadata}()}
}
\concept{database}
