% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-attributions.R
\encoding{UTF-8}
\name{gisco_attributions}
\alias{gisco_attributions}
\title{Attribution for administrative and statistical GISCO data}
\usage{
gisco_attributions(lang = "en", copyright = FALSE)
}
\arguments{
\item{lang}{character. Language (two-letter ISO code). See
\link[countrycode:codelist]{countrycode::codelist} and \strong{Details}.}

\item{copyright}{logical \code{TRUE/FALSE}. Whether to display the copyright
notice or not on the console.}
}
\value{
A string with the attribution to be used.
}
\description{
Get the legal text to be used for administrative and statistical data
downloaded from GISCO, see section \strong{Copyright information}.

For other datasets you may abide by the \href{https://ec.europa.eu/eurostat/web/main/help/copyright-notice}{Eurostat's general copyright notice and licence policy}.
}
\details{
Current languages supported are:
\itemize{
\item \code{"en"}: English.
\item \code{"da"}: Danish.
\item \code{"de"}: German.
\item \code{"es"}: Spanish.
\item \code{"fi"}: Finnish.
\item \code{"fr"}: French.
\item \code{"no"}: Norwegian.
\item \code{"sv"}: Swedish.
}

Please consider
\href{https://github.com/rOpenGov/giscoR/issues}{contributing} if you spot any
mistake or want to add a new language.
}
\section{Copyright information}{
The provisions described in this section apply to administrative and
statistical data provided by the following functions:

\strong{Administrative units}
\itemize{
\item \code{\link[=gisco_get_communes]{gisco_get_communes()}}
\item \code{\link[=gisco_get_countries]{gisco_get_countries()}}
\item \code{\link[=gisco_get_postal_codes]{gisco_get_postal_codes()}}
}

\strong{Statistical units}
\itemize{
\item \code{\link[=gisco_get_census]{gisco_get_census()}}
\item \code{\link[=gisco_get_coastal_lines]{gisco_get_coastal_lines()}}
\item \code{\link[=gisco_get_lau]{gisco_get_lau()}}
\item \code{\link[=gisco_get_nuts]{gisco_get_nuts()}}
\item \code{\link[=gisco_get_urban_audit]{gisco_get_urban_audit()}}
}
\subsection{Copyright Notice}{

When data downloaded from GISCO is used in any printed or electronic
publication, in addition to any other provisions applicable to the whole
Eurostat website, data source will have to be acknowledged in the legend of
the map and in the introductory page of the publication with the following
copyright notice:
\itemize{
\item EN: © EuroGeographics for the administrative boundaries.
\item FR: © EuroGeographics pour les limites administratives.
\item DE: © EuroGeographics bezüglich der Verwaltungsgrenzen.
}

For publications in languages other than English, French or German,
the translation of the copyright notice in the language of the publication
shall be used.

If you intend to use the data commercially, please contact EuroGeographics
for information regarding their licence agreements.
}
}

\examples{
gisco_attributions()

gisco_attributions(lang = "es", copyright = TRUE)

gisco_attributions(lang = "XXX")

# Get list of codes from countrycodes
library(dplyr)

countrycode::codelist |>
  select(country.name.en, iso2c)
}
\concept{misc}
