% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo.R, R/repo_branches.R, R/repo_clone_url.R,
%   R/repo_commits.R, R/repo_issues.R, R/repo_n_commits.R, R/repo_prs.R,
%   R/repo_pushes.R
\name{repo_details}
\alias{repo_details}
\alias{repo_branches}
\alias{repo_clone_url}
\alias{repo_commits}
\alias{repo_issues}
\alias{repo_n_commits}
\alias{repo_prs}
\alias{repo_pushes}
\title{GitHub Repository tools - repository details}
\usage{
repo_branches(repo)

repo_clone_url(repo, type = c("https", "ssh"))

repo_commits(
  repo,
  branch = NULL,
  sha = branch,
  path = NULL,
  author = NULL,
  since = NULL,
  until = NULL,
  quiet = FALSE
)

repo_issues(
  repo,
  state = c("open", "closed", "all"),
  assignee = NULL,
  creator = NULL,
  mentioned = NULL,
  labels = NULL,
  sort = c("created", "updated", "comments"),
  direction = c("desc", "asc"),
  since = NULL
)

repo_n_commits(repo, quiet = FALSE)

repo_prs(repo, state = c("open", "closed", "all"))

repo_pushes(
  repo,
  branch = NULL,
  author = NULL,
  time_period = c("all time", "day", "week", "month", "quarter", "year"),
  quiet = FALSE
)
}
\arguments{
\item{repo}{Character. Address of repository in \code{owner/name} format.}

\item{type}{Character. Clone url type, either "https" or "ssh".}

\item{branch}{Character.    Branch to list commits from.}

\item{sha}{Character.    SHA to start listing commits from.}

\item{path}{Character.    Only commits containing this file path will be returned.}

\item{author}{Character.    GitHub login or email address by which to filter commit author.}

\item{since}{Character. Only issues updated at or after this time are returned.}

\item{until}{Character.    Only commits before this date will be returned, expects \code{YYYY-MM-DDTHH:MM:SSZ} format.}

\item{quiet}{Logical. Should an error message be printed if a repo does not exist.}

\item{state}{Character. Pull request state.}

\item{assignee}{Character. Return issues assigned to a particular username.
Pass in "none" for issues with no assigned user, and "*" for issues assigned to any user.}

\item{creator}{Character. Return issues created the by the given username.}

\item{mentioned}{Character. Return issues that mentioned the given username.}

\item{labels}{Character. Return issues labeled with one or more of of the given label names.}

\item{sort}{Character. What to sort results by. Can be either "created", "updated", or "comments".}

\item{direction}{Character. The direction of the sort. Can be either "asc" or "desc".}

\item{time_period}{Character. The time period to filter by.
Options are  "all time", "day", "week", "month", "quarter", "year".}
}
\value{
\code{repo_clone_url()} and \code{repo_branches()} both return a character vector.

\code{repo_commits()}, \code{repo_issues()}, \code{repo_n_commits()}, and \code{repo_prs()} all return a tibble.
}
\description{
\itemize{
\item \code{repo_clone_url()} - Returns the url, for cloning, a GitHub repo (either ssh or https)
\item \code{repo_branches()} - Returns a (filtered) vector of branch names.
\item \code{repo_commits()} - Returns a tibble of commits to a GitHub repository.
\item \code{repo_issues()} - Returns a tibble of issues for a GitHub repository.
\item \code{repo_n_commits()} - Returns a tibble of the number of commits in a GitHub repository (and branch).
\item \code{repo_prs()} - Returns a tibble of pull requests for a GitHub repository.
\item \code{repo_pushes()} - Returns a tibble of push activity to a GitHub repository.
}
}
\examples{
\dontrun{
repo_clone_url("rundel/ghclass")

repo_branches("rundel/ghclass")

repo_commits("rundel/ghclass")

repo_issues("rundel/ghclass")

repo_n_commits("rundel/ghclass", branch = "master")

repo_prs("rundel/ghclass")
}

}
