% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.prestonfit.R
\name{fortify.prestonfit}
\alias{fortify.prestonfit}
\alias{tidy.prestonfit}
\title{Tidied species octave abundance data}
\usage{
\method{fortify}{prestonfit}(model, data, ...)

\method{tidy}{prestonfit}(x, data, ...)
}
\arguments{
\item{model, x}{an object of class \code{\link[vegan:fisherfit]{vegan::prestonfit()}}.}

\item{data}{original data set. Currently ignored.}

\item{...}{other arguments pass to methods. Currently ignored.}
}
\value{
A data frame with columns \verb{'Octave'`` and }'Abundance'``.
}
\description{
Prepares a data frame of results from a \code{\link[vegan:fisherfit]{vegan::prestonfit()}}
object suitable for plotting with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\examples{

library("vegan")

data(BCI)
pfit <- prestonfit(colSums(BCI))
fortify(pfit)
}
\author{
Gavin L. Simpson
}
