% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.cca.R
\name{fortify.cca}
\alias{fortify.cca}
\alias{tidy.cca}
\title{Fortify a \code{"cca"} object.}
\usage{
\method{fortify}{cca}(model, data, axes = 1:6, layers = c("sp", "wa", "lc", "bp", "cn"), ...)

\method{tidy}{cca}(x, data, axes = 1:6, layers = c("sp", "wa", "lc", "bp", "cn"), ...)
}
\arguments{
\item{model, x}{an object of class \code{"cca"}, the result of a call to
\code{\link[vegan:cca]{vegan::cca()}}, \code{\link[vegan:cca]{vegan::rda()}}, or \code{\link[vegan:dbrda]{vegan::capscale()}}.}

\item{data}{currently ignored.}

\item{axes}{numeric; which axes to extract scores for.}

\item{layers}{character; the scores to extract in the fortified object.
Passed to \code{display} in the respective \code{\link[vegan:scores]{vegan::scores()}} method.}

\item{...}{additional arguments passed to \code{\link[vegan:plot.cca]{vegan::scores.cca()}}.}
}
\value{
A data frame (tibble) in long format containing the ordination
scores. The first two components are \code{score} (the type of score in each
row) and \code{label} (the text label to use on plots for this row). The
remaining columns are the extracted ordination axis scores.
}
\description{
Fortifies an object of class \code{"cca"} to produce a
data frame of the selected axis scores in long format, suitable for
plotting with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\details{
TODO
}
\examples{

library("vegan")

data(dune)
data(dune.env)

sol <- cca(dune ~ A1 + Management, data = dune.env)
head(fortify(sol))
}
\author{
Gavin L. Simpson
}
