% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.poolaccum.R
\name{autoplot.poolaccum}
\alias{autoplot.poolaccum}
\title{ggplot-based plot for objects of class \code{"poolaccum"}}
\usage{
\method{autoplot}{poolaccum}(
  object,
  facet = TRUE,
  ribbon = facet,
  ncol = NULL,
  ribbon.alpha = 0.3,
  xlab = "Size",
  ylab = "Richness",
  title = "Accumulated species richness",
  subtitle = NULL,
  caption = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"poolaccum"}, the result of a call to
\code{\link[vegan:specpool]{vegan::poolaccum()}}.}

\item{facet}{logical; should extrapolated richness estimators be shown in
separate facets?}

\item{ribbon}{logical; show the quantile-based uncertainty interval? Uses
\code{\link[ggplot2:geom_ribbon]{ggplot2::geom_ribbon()}} for plot.}

\item{ncol}{numeric; if faceting the plot, how many columns to use. Default
arguments will result in three columns.}

\item{ribbon.alpha}{numeric; alpha transparency used for the uncertainty
interval. Passed to the \code{alpha} aesthetic of \code{\link[ggplot2:geom_ribbon]{ggplot2::geom_ribbon()}}.}

\item{xlab}{character; label for the x axis.}

\item{ylab}{character; label for the y axis.}

\item{title}{character; title for the plot.}

\item{subtitle}{character; subtitle for the plot.}

\item{caption}{character; caption for the plot.}

\item{...}{additional arguments passed to \code{\link[=fortify.poolaccum]{fortify.poolaccum()}}.}
}
\value{
A ggplot object.
}
\description{
Produces a multi-layer ggplot object representing the output of objects
produced by \code{\link[vegan:specpool]{vegan::poolaccum()}}.
}
\examples{

library("vegan")

data(BCI)
pool <- poolaccum(BCI)

autoplot(pool)

## Turn off facetting; turns off ribbon too
autoplot(pool, facet = FALSE)
}
\author{
Didzis Elferts & Gavin L. Simpson
}
