% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.decorana.R
\name{autoplot.decorana}
\alias{autoplot.decorana}
\title{ggplot-based plot for objects of class \code{"decorana"}}
\usage{
\method{autoplot}{decorana}(
  object,
  axes = c(1, 2),
  geom = c("point", "text"),
  layers = c("sites", "species"),
  legend.position = "right",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ylab,
  xlab,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"decorana"}, the result of a call to
\code{\link[vegan:decorana]{vegan::decorana()}}.}

\item{axes}{numeric; which axes to plot, given as a vector of length 2.}

\item{geom}{character; which geom to use for the species (variables) and
sites (samples) layers. A vector of length 2; if a vector of length 1,
\code{geom} is extended to the required length.}

\item{layers}{character; which scores to plot as layers}

\item{legend.position}{character or two-element numeric vector; where to
position the legend. See \code{\link[ggplot2:theme]{ggplot2::theme()}} for details. Use \code{"none"}
to not draw the legend.}

\item{title}{character; subtitle for the plot.}

\item{subtitle}{character; subtitle for the plot.}

\item{caption}{character; caption for the plot.}

\item{ylab}{character; label for the y-axis.}

\item{xlab}{character; label for the x-axis.}

\item{...}{Additional arguments passed to \code{\link[=fortify.decorana]{fortify.decorana()}}.}
}
\value{
Returns a ggplot object.
}
\description{
Produces a multi-layer ggplot object representing the output of objects
produced by \code{\link[vegan:decorana]{vegan::decorana()}}.
}
\details{
TODO
}
\examples{

library("vegan")
data(dune)

sol <- decorana(dune)
autoplot(sol)
autoplot(sol, layers = "species", geom = "text")
}
\author{
Gavin L. Simpson
}
