% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas-convert.R
\name{convert_legacy_brain_atlas}
\alias{convert_legacy_brain_atlas}
\alias{unify_legacy_atlases}
\title{Convert legacy ggseg atlases to ggseg_atlas format}
\usage{
convert_legacy_brain_atlas(
  atlas_2d = NULL,
  atlas_3d = NULL,
  atlas_name = NULL,
  type = NULL,
  surface = "inflated",
  brain_meshes = NULL
)

unify_legacy_atlases(
  atlas_2d = NULL,
  atlas_3d = NULL,
  atlas_name = NULL,
  type = NULL,
  surface = "inflated",
  brain_meshes = NULL
)
}
\arguments{
\item{atlas_2d}{A \code{ggseg_atlas} (or legacy \code{brain_atlas}) with 2D geometry,
or NULL.}

\item{atlas_3d}{A \code{ggseg3d_atlas} with mesh data, or NULL.}

\item{atlas_name}{Name for the output atlas. If NULL, derived from input.}

\item{type}{Atlas type: \code{"cortical"} or \code{"subcortical"}. If NULL, inferred
from the input atlases.}

\item{surface}{Which surface to match against when inferring vertices
(e.g., \code{"inflated"}). Must match the 3D atlas surface exactly.}

\item{brain_meshes}{Optional user-supplied brain meshes for vertex
inference.}
}
\value{
A \code{ggseg_atlas} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Convert old-style ggseg (2D) and ggseg3d (3D) atlases into the new
\code{ggseg_atlas} format. This is a bridge function for working with existing
atlases during the transition period.

For new atlases, use \code{ggsegExtra::create_cortical_atlas()} or
\code{ggsegExtra::create_subcortical_atlas()}
instead - they produce better results with proper vertex indices.

The function handles three scenarios:
\itemize{
\item \strong{Both 2D and 3D}: Merges geometry with vertex data
\item \strong{3D only}: Extracts vertices, infers indices from mesh coordinates
\item \strong{2D only}: Keeps geometry, 3D rendering unavailable
}

If the 3D atlas already contains vertex indices (newer ggseg3d atlases),
those are preserved. Otherwise, vertex indices are inferred from mesh
coordinates using hash-based matching (no FreeSurfer needed).
}
\examples{
\donttest{
new_atlas <- convert_legacy_brain_atlas(atlas_2d = dk())
}
}
