% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_argsort}
\alias{ggml_argsort}
\title{Argsort - Get Sorting Indices (Graph)}
\usage{
ggml_argsort(ctx, a, order = GGML_SORT_ORDER_ASC)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor to sort (F32)}

\item{order}{Sort order: GGML_SORT_ORDER_ASC (0) or GGML_SORT_ORDER_DESC (1)}
}
\value{
Tensor of I32 indices that would sort each row
}
\description{
Returns indices that would sort the tensor rows.
Each row is sorted independently.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
# Create tensor with values to sort
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(3, 1, 4, 1, 5))
# Get indices for ascending sort
indices <- ggml_argsort(ctx, a, GGML_SORT_ORDER_ASC)
graph <- ggml_build_forward_expand(ctx, indices)
ggml_graph_compute(ctx, graph)
result <- ggml_get_i32(indices)
# result: [1, 3, 0, 2, 4] (0-indexed positions for sorted order)
ggml_free(ctx)
}
}
