% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_add1}
\alias{ggml_add1}
\title{Add Scalar to Tensor (Graph)}
\usage{
ggml_add1(ctx, a, b)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}

\item{b}{Scalar tensor (1-element tensor)}
}
\value{
Tensor representing the operation a + b (broadcasted)
}
\description{
Creates a graph node for adding a scalar (1-element tensor) to all elements
of a tensor. This is more efficient than creating a full tensor of the same value.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
scalar <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 1)
ggml_set_f32(a, c(1, 2, 3, 4, 5))
ggml_set_f32(scalar, 10)
result <- ggml_add1(ctx, a, scalar)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_get_f32(result)
ggml_free(ctx)
}
}
