% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_node_1_index_r}
\alias{get_node_1_index_r}
\title{Get Index Mapping for the Node 1 Accumulator}
\usage{
get_node_1_index_r(parameter_map_r, factors_r, accumulators_r)
}
\arguments{
\item{parameter_map_r}{An Rcpp::List where each element is a character
vector mapping parameters to conditions. Names should correspond to
parameters.}

\item{factors_r}{An Rcpp::List where each element is a character
vector of factor levels. Names should correspond to factor names.}

\item{accumulators_r}{A character vector of response accumulator names.}
}
\value{
An integer matrix with dimensions:
\itemize{
  \item Rows: Experimental conditions (cells)
  \item Columns: Accumulators (responses)
}
Where values represent parameter indices for each condition-response
combination.
}
\description{
Generates an integer matrix mapping experimental design cells to their
corresponding indexes of the node 1 accumulator. The node 1 accumulator
is the theoretical accumulator that reaches the threshold first. This 
function is primarily used for the LBA model.
}
\details{
The function:
\enumerate{
  \item Computes node indices for each condition-response pair
  \item Returns results as an R-compatible integer matrix
}
}
\examples{
cat("Flexible stimulus name")
p_map <- list(A = "1", B = "S", t0 = "E", mean_v = c("D", "M"),
               sd_v = "M", st0 = "1")
factors <- list(S = c("sti_1", "sti_2", "sti_3", "sti_4"),
                D = c("d1", "d2"), E = c("e1", "e2"))
responses <- c("resp_1", "resp_2", "resp_3", "resp_4")

# Get node indices
result <- get_node_1_index_r(p_map, factors, responses)
print(dim(result)[[1]])
# 64

}
