% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggInterval_MMplot.R
\name{ggInterval_MMplot}
\alias{ggInterval_MMplot}
\title{A min-max plot for interval data}
\usage{
ggInterval_MMplot(data = NULL,mapping = aes(NULL),
          scaleXY = "local",plotAll=FALSE)
}
\arguments{
\item{data}{A ggInterval object. It can also be either RSDA object or
classical data frame,which will be automatically convert to ggInterval
data.}

\item{mapping}{Set of aesthetic mappings created by aes() or aes_().
If specified and inherit. aes = TRUE (the default),
it is combined with the default mapping at the top level of
the plot. You must supply mapping if there is no plot mapping.}

\item{scaleXY}{default "local", which means limits of x-axis and y-axis
depend on their own variable. "global" means limits of them depend on all
variables that user input.}

\item{plotAll}{booleans, if TRUE, plot all variable together}
}
\value{
Return a ggplot2 object.
}
\description{
Visualize the range of the variables of each observations
by marking minimal and maximal point.
}
\examples{
ggInterval_MMplot(mtcars,aes(disp))

mydata2<-ggInterval::Cardiological
ggInterval_MMplot(mydata2,aes(mydata2$Pulse,size=3))

d<-mapply(c(10,20,40,80,160),c(20,40,80,160,320),FUN=runif,n=1000)
d<-data.frame(qq=matrix(d,ncol=1))
ggInterval_MMplot(d,aes(qq))

myIris<-classic2sym(iris,groupby="Species")
myIris<-myIris$intervalData
ggInterval_MMplot(myIris,aes(myIris$Petal.Length))+
   theme_classic()
}
