% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l2_fusion.R
\name{fusedL2DescentGLMNet}
\alias{fusedL2DescentGLMNet}
\title{Optimise the fused L2 model with glmnet (using transformed input data)}
\usage{
fusedL2DescentGLMNet(transformed.x, transformed.x.f, transformed.y, groups,
  lambda, gamma = 1, ...)
}
\arguments{
\item{transformed.x}{Transformed covariates (output of generateBlockDiagonalMatrices)}

\item{transformed.x.f}{Transformed fusion constraints (output of generateBlockDiagonalMatrices)}

\item{transformed.y}{Transformed response (output of generateBlockDiagonalMatrices)}

\item{groups}{Grouping factors for samples (a vector of size n, with K factor levels)}

\item{lambda}{Sparsity penalty hyperparameter}

\item{gamma}{Fusion penalty hyperparameter}

\item{...}{Further options passed to glmnet.}
}
\value{
Matrix of fitted beta values.

A matrix with the linear coefficients for each group (p by k).
}
\description{
Optimise the fused L2 model with glmnet (using transformed input data)
}
\examples{

#' set.seed(123)

# Generate simple heterogeneous dataset
k = 4 # number of groups
p = 100 # number of covariates
n.group = 15 # number of samples per group
sigma = 0.05 # observation noise sd
groups = rep(1:k, each=n.group) # group indicators
# sparse linear coefficients
beta = matrix(0, p, k)
nonzero.ind = rbinom(p*k, 1, 0.025/k) # Independent coefficients
nonzero.shared = rbinom(p, 1, 0.025) # shared coefficients
beta[which(nonzero.ind==1)] = rnorm(sum(nonzero.ind), 1, 0.25)
beta[which(nonzero.shared==1),] = rnorm(sum(nonzero.shared), -1, 0.25)

X = lapply(1:k,
           function(k.i) matrix(rnorm(n.group*p),
                                n.group, p)) # covariates
y = sapply(1:k,
           function(k.i) X[[k.i]] \%*\% beta[,k.i] +
                           rnorm(n.group, 0, sigma)) # response
X = do.call('rbind', X)

# Pairwise Fusion strength hyperparameters (tau(k,k'))
# Same for all pairs in this example
G = matrix(1, k, k)

# Generate block diagonal matrices
transformed.data = generateBlockDiagonalMatrices(X, y, groups, G)

# Use L2 fusion to estimate betas (with near-optimal information
# sharing among groups)
beta.estimate = fusedL2DescentGLMNet(transformed.data$X,
                                     transformed.data$X.fused,
                                     transformed.data$Y, groups,
                                     lambda=c(0,0.001,0.1,1),
                                     gamma=0.001)
}
