% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_sums.R
\name{column_sums}
\alias{column_sums}
\title{Sum up the Numeric Columns of a Data Frame}
\usage{
column_sums(x, ...)
}
\arguments{
\item{x}{A  \code{\link{data.frame}}.}

\item{...}{Arguments passed to \code{\link{colSums}}.}
}
\value{
A named vector of column sums (see \code{\link{colSums}}).
}
\description{
I often need to calculate the sums of the numeric columns of a
\code{\link{data.frame}}. While \code{\link{colSums}} requires the data frame
to be numeric, this is a convenience wrapper to select numeric columns only.
}
\examples{
try(colSums(iris))
column_sums(iris)
names(iris) # no column sum for `Species`
}
\seealso{
Other statistics: 
\code{\link{count_groups}()},
\code{\link{powers_of_ten}},
\code{\link{relative_difference}()},
\code{\link{round_half_away_from_zero}()},
\code{\link{sloboda}()},
\code{\link{weighted_variance}()}
}
\concept{statistics}
