% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{save_figure}
\alias{save_figure}
\title{Save a figure to the outputs directory}
\usage{
save_figure(
  plot = NULL,
  name,
  format = "png",
  width = 8,
  height = 6,
  dpi = 300,
  public = FALSE,
  overwrite = TRUE,
  ...
)
}
\arguments{
\item{plot}{A ggplot2 object, or NULL to save the current plot}

\item{name}{The name for the output file (without extension)}

\item{format}{Output format: "png" (default), "pdf", "svg", or "jpg"}

\item{width}{Width in inches (default: 8)}

\item{height}{Height in inches (default: 6)}

\item{dpi}{Resolution in dots per inch (default: 300)}

\item{public}{If TRUE, saves to public outputs directory (for project_sensitive type)}

\item{overwrite}{If TRUE, overwrites existing files (default: TRUE)}

\item{...}{Additional arguments passed to ggsave or the graphics device}
}
\value{
The path to the saved file (invisibly)
}
\description{
Saves a ggplot2 plot or base R graphics to the configured figures directory.
The directory is created lazily on first use.
}
\examples{
\donttest{
if (FALSE) {
# Save a ggplot
p <- ggplot(mtcars, aes(mpg, hp)) + geom_point()
save_figure(p, "mpg_vs_hp")

# Save as PDF for publication
save_figure(p, "mpg_vs_hp", format = "pdf", width = 10, height = 8)

# Save to public directory
save_figure(p, "summary_plot", public = TRUE)
}
}

}
