% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete_ranks.R
\name{discrete_ranks}
\alias{discrete_ranks}
\title{roxygen documentation}
\usage{
discrete_ranks(x, ranks = NULL)
}
\arguments{
\item{x}{A dataframe containing hierarchically structured
information, for example a table of genus names and their
higher taxonomic classifications}

\item{ranks}{If not NULL, a vector of column names of x,
given in rank order. This is useful if x contains columns
which are not rank relevant or if columns are not in
hierarchical order. If not supplied, the column order in x
is used directly and is assumed to be in rank order}
}
\value{
A list of two lists. The first list contains names
which reoccur at adjacent ranks. The second list contains
names that reoccur at any rank
}
\description{
discrete_ranks
}
\details{
Function for checking whether names in one column of a
hierarchically organised dataframe re-occur at other levels.
Two checks are performed. The first checks for names in
adjacent column, assuming that accidental reuse of names at
other levels are most likely to occur at an adjacent rank.
The second compares across all columns.
}
\examples{
# load dataset
data("brachios")
# define ranks
b_ranks <- c("phylum", "class", "order", "family", "genus")
# run function
flag <- discrete_ranks(brachios, ranks = b_ranks)
}
