% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_englue.R
\name{str_englue}
\alias{str_englue}
\title{Dynamic plot labels using glue operators}
\usage{
str_englue(x, env, error_call, error_arg)
}
\arguments{
\item{x}{A string to interpolate with glue operators.}

\item{env}{User environment where the interpolation data lives in
case you're wrapping \code{englue()} in another function.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{error_arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}
}
\description{
\code{str_englue()} helps you solve the labeling problem during plotting. For example, any value wrapped in \code{{ }} will be inserted into the string and it can also understands embracing, \code{{{ }}}, which automatically inserts a given variable name.
}
\examples{
\donttest{
library(ggplot2)

histogram_plot <- function(df, var, binwidth) {
   ggplot(df, aes(x = {{ var }})) +
   geom_histogram(binwidth = binwidth) +
   labs(title = str_englue("A histogram of {{var}} with binwidth {binwidth}"))
}

histogram_plot(iris, Sepal.Length, binwidth = 0.1)
}

}
\seealso{
\code{\link[rlang:englue]{rlang::englue()}}
}
