% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{load_mult}
\alias{load_mult}
\title{Load Multiple Measurements}
\usage{
load_mult(folder, columns = c(1:2), show.progress = FALSE)
}
\arguments{
\item{folder}{Character string containing the path to the measurements.}

\item{columns}{A vector of column numbers. The first entry will be used as the x-axis values, the second entry as y-axis values.
All other columns will be ignored. Default: \code{c(1,2)}.}

\item{show.progress}{A logical value indicating if progress should be
printed to the console. Default: \code{FALSE}.}
}
\value{
Returns a tibble in the format\tabular{ccc}{
   \strong{\code{t}} \tab \strong{\code{y}} \tab \strong{\code{filename}} \cr
   \code{t.1} \tab \code{y.1} \tab \code{...} \cr
   \code{...} \tab \code{...} \tab \code{...} \cr
   \code{t.n} \tab \code{y.n} \tab \code{...} \cr
}
}
\description{
Loads multiple measurements.
}
\details{
The input files need to be in the following format (even though column names do not matter):\tabular{cc}{
   \strong{\code{t}} \tab \strong{\code{y}} \cr
   \code{t.1} \tab \code{y.1} \cr
   \code{...} \tab \code{...} \cr
   \code{t.n} \tab \code{y.n} \cr
}


All columns except the first two are removed.
}
\examples{
# store name of folder that contains files
input.folder <- forceR_example(type = "folder")

# load a mutiple files
df.all <- load_mult(folder = input.folder,
                    columns = c(1:2),
                    show.progress = FALSE)
}
