% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_company_name}
\alias{normalize_company_name}
\title{Normalize Company Names}
\usage{
normalize_company_name(x)
}
\arguments{
\item{x}{A character vector of company names.}
}
\value{
A character vector of normalized names.
}
\description{
Standardizes company names by lowercasing, removing legal suffixes,
translating characters to ASCII, and removing noise words.
}
\examples{
# Normalize a single company name
normalize_company_name("BMW AG")
normalize_company_name("Siemens GmbH & Co. KG")

# Normalize multiple names
companies <- c("Deutsche Bank AG", "VW Group", "BASF SE")
normalize_company_name(companies)
}
