% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figma.R
\name{get_document_info}
\alias{get_document_info}
\title{Get the document metadata of a Figma File from the API}
\usage{
get_document_info(file_key, token, .output_format = "list")
}
\arguments{
\item{file_key}{A string with the key of the Figma File you want to get;}

\item{token}{A string with your personal Figma token to authenticate in the API;}

\item{.output_format}{The output format. Options are \code{"list"} and
\code{"tibble"}. Defaults to \code{"list"};}
}
\value{
By default, \code{get_document_info()} returns a raw R list with all
of the document metadata of your Figma file. But you can change this
behavior with \code{.output_format = "tibble"}, which gives you
a \code{tibble::tibble} object.
}
\description{
This function uses the \code{/v1/files/} endpoint of Figma API
to get all of the document metadata of a particular Figma file,
and fit it into a R object.
}
\details{
You may not be interested in the contents of a Figma file, but in the
metadata of this file instead. That is, you want to know the "name"
of a particular Figma file, the last time it was modified, which version
it uses, etc.

That is why \code{get_document_info()} exists. It collects just the
metadata of your Figma file, and ignores all canvas and objects data.

By default, \code{get_document_info()} fits the metadata into a raw R list.
But you can change this behavior with the \code{.output_format} argument.
With \code{.output_format = "tibble"}, \code{get_document_info()} will
fit the metadata into a \code{tibble::tibble} object.
}
\section{Be aware of possible HTTP errors}{

To get the data of your Figma file, the functions from \code{figma} package make a HTTP
request to the Figma API. But this request can fail for a number of reasons, and if this
does happen, \code{get_document_info()} will use \code{report_http_error()} to raise an error
and report to the user, what kind of error message the Figma API returned.
See \code{vignette("http-errors")} for more details.
}

\examples{
\dontrun{
library(figma)
file_key <- "hch8YlkgaUIZ9raDzjPvCz"
token <- "my figma token secret ... "
# Returns a list with the metadata:
result <- figma::get_document_info(file_key, token)
# Returns a `tibble` object:
result <- figma::get_document_info(
  file_key, token,
  .output_format = "tibble"
)
}
}
