% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_set.R
\name{Set}
\alias{Set}
\title{R6 class for a fuzzy set with sparse internal representation}
\description{
This class implements the data structure and methods for fuzzy sets.
}
\examples{
S <- Set$new(attributes = c("A", "B", "C"))
S$assign(A = 1)
print(S)
S$to_latex()

S <- Set$new(c("A", "B", "C"), C = 1, B = 0.5)
S

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Set-new}{\code{Set$new()}}
\item \href{#method-Set-assign}{\code{Set$assign()}}
\item \href{#method-Set-bracket}{\code{Set$[()}}
\item \href{#method-Set-cardinal}{\code{Set$cardinal()}}
\item \href{#method-Set-get_vector}{\code{Set$get_vector()}}
\item \href{#method-Set-get_attributes}{\code{Set$get_attributes()}}
\item \href{#method-Set-length}{\code{Set$length()}}
\item \href{#method-Set-print}{\code{Set$print()}}
\item \href{#method-Set-to_latex}{\code{Set$to_latex()}}
\item \href{#method-Set-clone}{\code{Set$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-new"></a>}}
\if{latex}{\out{\hypertarget{method-Set-new}{}}}
\subsection{Method \code{new()}}{
Creator for objects of class \code{Set}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$new(attributes, M = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{attributes}}{(character vector) Names of the attributes that will be available in the fuzzy set.}

\item{\code{M}}{(numeric vector or column \code{Matrix}) Values (grades) to be assigned to the attributes.}

\item{\code{...}}{\code{key} = \code{value} pairs, where the value \code{value} is assigned to the \code{key} attribute name.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If \code{M} is omitted and no pair \code{key} = \code{value}, the fuzzy set is the empty set. Later, one can use the \code{assign} method to assign grades to any of its attributes.
}

\subsection{Returns}{
An object of class \code{Set}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-assign"></a>}}
\if{latex}{\out{\hypertarget{method-Set-assign}{}}}
\subsection{Method \code{assign()}}{
Assign grades to attributes in the set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$assign(..., attributes = c(), values = c())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{key} = \code{value} pairs, where the value \code{value} is assigned to the \code{key} attribute name.}

\item{\code{attributes}}{(character vector) Names of the attributes to assign a grade to.}

\item{\code{values}}{(numeric vector) Grades to be assigned to the previous \code{attributes}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
One can use both of:
\code{S$assign(A = 1, B = 0.3)}
\code{S$assign(attributes = c(A, B), values = c(1, 0.3))}.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-bracket"></a>}}
\if{latex}{\out{\hypertarget{method-Set-bracket}{}}}
\subsection{Method \code{[()}}{
Get elements by index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$[(indices)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{indices}}{(numeric, logical or character vector) The indices of the elements to return. It can be a vector of logicals where \code{TRUE} elements are to be retained.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Set} but with only the required elements.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-cardinal"></a>}}
\if{latex}{\out{\hypertarget{method-Set-cardinal}{}}}
\subsection{Method \code{cardinal()}}{
Cardinal of the Set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$cardinal()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the cardinal of the \code{Set}, counted
as the sum of the degrees of each element.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-get_vector"></a>}}
\if{latex}{\out{\hypertarget{method-Set-get_vector}{}}}
\subsection{Method \code{get_vector()}}{
Internal \code{Matrix}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$get_vector()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The internal sparse \code{Matrix} representation of the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-get_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-Set-get_attributes}{}}}
\subsection{Method \code{get_attributes()}}{
Attributes defined for the set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$get_attributes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector with the names of the attributes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-length"></a>}}
\if{latex}{\out{\hypertarget{method-Set-length}{}}}
\subsection{Method \code{length()}}{
Number of attributes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$length()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The number of attributes that are defined for this fuzzy set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-print"></a>}}
\if{latex}{\out{\hypertarget{method-Set-print}{}}}
\subsection{Method \code{print()}}{
Prints the set to console
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$print(eol = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{eol}}{(logical) If \code{TRUE}, adds an end of line to the output.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A string with the elements of the set and their grades between brackets {}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-to_latex"></a>}}
\if{latex}{\out{\hypertarget{method-Set-to_latex}{}}}
\subsection{Method \code{to_latex()}}{
Write the set in LaTeX format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$to_latex(print = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{print}}{(logical) Print to output?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The fuzzy set in LaTeX.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Set-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Set-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
