% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_experts.R
\name{analyse_experts}
\alias{analyse_experts}
\title{Analyse and Visualise Expert Network Specialisation}
\usage{
analyse_experts(
  gnn_results,
  prepared_data,
  group_mappings = NULL,
  top_n_features = 10,
  verbose = FALSE
)
}
\arguments{
\item{gnn_results}{A list from \code{train_gnn()}.}

\item{prepared_data}{A list from \code{prepare_data()} (used to retrieve group mappings if not provided).}

\item{group_mappings}{Optional named mapping from group codes (names) to labels (values).}

\item{top_n_features}{Integer; number of top features to visualise.}

\item{verbose}{Logical; print progress messages.}
}
\value{
A list with:
\item{all_weights}{Long table of feature importances by group & repeat}
\item{means_by_group_wide}{Wide table of per-feature mean importance per group}
\item{pairwise_differences}{Named list of B_vs_A difference tables (descriptive)}
\item{difference_plot}{ggplot; only when there are exactly 2 groups}
\item{multi_group_plot}{ggplot; only when there are >2 groups}
\item{top_features_multi}{Long table used for the multi-group plot}
}
\description{
Analyses expert input weights to determine which features are most
important per subgroup. For two groups, returns a signed
difference plot (GroupB - GroupA). For >2 groups, performs a
non-inferential analysis: per-group mean importances, pairwise
(B - A) difference tables for all pairs, and a multi-group plot
for the features with the largest max-min spread across groups.
}
