% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enroll.R
\name{enroll}
\alias{enroll}
\title{enroll faces}
\usage{
enroll(image, subject_id, gallery, min_head_scale = 0.015)
}
\arguments{
\item{image}{An image of file type 'JPG', 'PNG', or 'BMP'.
Can either be an url string or a local image processed with \code{\link[facerec]{prep_image}}.}

\item{subject_id}{A string containing the id to assign for the person in the enrolled image.}

\item{gallery}{A string containing the name of the gallery in which the image will be enrolled.}

\item{min_head_scale}{Set the ratio of the smallest face to look for in the input image. Accepts a value between .015 (1:64 scale) and .5 (1:2 scale).}
}
\value{
A data frame with annotations for the enrolled image.
}
\description{
Enroll face in an input image to a gallery and assign a subject id.
}
\examples{
\donttest{

facerec_init()

finn_image <- 'https://upload.wikimedia.org/wikipedia/en/2/2a/Finn-Force_Awakens_\%282015\%29.png'
finn_enroll <- enroll(image = finn_image, subject_id = 'finn', gallery = 'starwars')
}


}
