% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\name{update_pkg}
\alias{update_pkg}
\title{Update R Packages}
\usage{
update_pkg(pkg = NULL, source = NULL, ...)
}
\arguments{
\item{pkg}{Character vector. Package name(s) to update. For GitHub, use
\code{"user/repo"} format. Only required when \code{source} is specified.}

\item{source}{Character. Package source: "CRAN", "GitHub", or "Bioconductor".
Optional if updating all installed CRAN and Bioconductor packages.}

\item{...}{Additional arguments passed to \code{\link[utils]{install.packages}},
\code{\link[devtools]{install_github}}, or \code{\link[BiocManager]{install}}.}
}
\value{
NULL (invisibly). Side effect: updates packages.
}
\description{
Update R packages from CRAN, GitHub, or Bioconductor. Supports full updates,
source-specific updates, or targeted package updates. Automatically handles
version compatibility checks and respects mirror settings.
}
\examples{
\dontrun{
# Update all CRAN + Bioconductor packages:
update_pkg()

# Update all CRAN packages only:
update_pkg(source = "CRAN")

# Update specific package:
update_pkg("ggplot2", source = "CRAN")

# Update GitHub package:
update_pkg("hadley/ggplot2", source = "GitHub")
}

}
