% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.dgw_sp.R
\name{b2dspL-ergmTerm}
\alias{b2dspL-ergmTerm}
\alias{InitErgmTerm.b2dspL}
\title{Dyadwise shared partners for dyads in the second bipartition on layers}
\usage{
# binary: b2dspL(d, Ls.path=NULL)
}
\arguments{
\item{d}{a vector of distinct integers}

\item{Ls.path, L.in_order}{a vector of one or two formulas \code{Ls.path}
provides the Layer Logic (c.f. Layer Logic section in the
\code{\link[=Layer]{Layer()}} documentation) specifications for the ties of the
2-path or the shared partnership. (If only one formula is given
the layers are assumed to be the same.) If \code{L.in_order==TRUE} ,
the first tie of the two-path must be the first element of
\code{Ls.path} and the second must be the second; otherwise, any
ordering counts, provided there is exactly one of each. (For
types \code{"OSP"} and \code{"ISP"} , the first tie is considered to be the
one incident on the tail of the base tie.)}
}
\description{
This term adds one network statistic to the model for each element in \code{d} ; the \eqn{i} th
such statistic equals the number of dyads in the second bipartition with exactly
\code{d[i]} shared partners. (Those shared partners, of course, must be members
of the first bipartition.) This term can only be used with bipartite networks.
}
\note{
This term does not support multilayer networks with
heterogeneous bipartedness. This may change in the future.

This term takes an additional term option (see
\code{\link[ergm:ergm-options]{options?ergm}}), \code{cache.sp}, controlling whether
the implementation will cache the number of shared partners for
each dyad in the network; this is usually enabled by default.
}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b2dspL", "subsection")}
}
\concept{bipartite}
\concept{layer-aware}
\concept{undirected}
