% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_sir.R
\name{setup_python_deps}
\alias{setup_python_deps}
\title{Set up Python dependencies for epiworldRcalibrate}
\usage{
setup_python_deps(force = FALSE)
}
\arguments{
\item{force}{Logical; if \code{TRUE}, removes and recreates the virtual
environment from scratch. Default is \code{FALSE}.}
}
\value{
Invisibly returns \code{TRUE} on success.
}
\description{
This function creates a dedicated virtual environment and installs all
required Python packages (numpy, scikit-learn, joblib, PyTorch). Run this
once after installing the package. This is kept separate from model
functions so that package installation never happens automatically during
normal use.
}
\details{
The function performs the following steps:
\enumerate{
\item Finds a suitable Python installation (or uses
\code{RETICULATE_PYTHON} if set).
\item Creates a virtual environment named \code{"epiworldRcalibrate"}.
\item Installs \code{numpy}, \code{scikit-learn}, \code{joblib}, and
\code{torch} (CPU version) into the virtual environment.
\item Verifies all packages can be imported.
}
}
\examples{
\dontrun{
# First-time setup (run once after installing the package)
setup_python_deps()

# Force reinstall if something went wrong
setup_python_deps(force = TRUE)
}

}
