% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steplist.R
\name{new_steplist}
\alias{new_steplist}
\alias{validate_steplist}
\alias{empty_steplist}
\alias{print.epicmodel_steplist}
\alias{print.epicmodel_steplist_checked}
\alias{summary.epicmodel_steplist}
\alias{summary.epicmodel_steplist_checked}
\alias{plot.epicmodel_steplist}
\alias{plot.epicmodel_steplist_checked}
\title{Steplist objects}
\usage{
new_steplist(x = list())

validate_steplist(x)

empty_steplist()

\method{print}{epicmodel_steplist}(x, ...)

\method{print}{epicmodel_steplist_checked}(x, ...)

\method{summary}{epicmodel_steplist}(object, ...)

\method{summary}{epicmodel_steplist_checked}(object, ...)

\method{plot}{epicmodel_steplist}(x, ...)

\method{plot}{epicmodel_steplist_checked}(x, modules = TRUE, module_colors = NULL, render = TRUE, ...)
}
\arguments{
\item{x}{\code{x} is used in several functions:
\itemize{
\item \code{new_steplist()}: A list to be converted to class \code{epicmodel_steplist}.
\item \code{validate_steplist()}: An object of class \code{epicmodel_steplist} or \code{epicmodel_steplist_checked} to be validated.
\item \code{print.epicmodel_steplist()}: An object of class \code{epicmodel_steplist}.
\item \code{print.epicmodel_steplist_checked()}: An object of class \code{epicmodel_steplist_checked}.
\item \code{plot.epicmodel_steplist()}: An object of class \code{epicmodel_steplist}.
\item \code{plot.epicmodel_steplist_checked()}: An object of class \code{epicmodel_steplist_checked}.
}}

\item{...}{Additional arguments for generics \code{print()}, \code{summary()}, and \code{plot()}.}

\item{object}{For \code{summary.epicmodel_steplist()}, an object of class \code{epicmodel_steplist}. For \code{summary.epicmodel_steplist_checked()}, an object
of class \code{epicmodel_steplist_checked}.}

\item{modules}{For \code{plot.epicmodel_steplist_checked}, TRUE (default) or FALSE, indicating if nodes in the same module should be colored equally
(TRUE) or if all nodes have white background (FALSE). Colors are only applied, if modules have actually been specified in the
\code{epicmodel_steplist}.}

\item{module_colors}{For \code{plot.epicmodel_steplist_checked}, if nodes are colored by module, colors can be provided via this argument. Colors
must be provided as a character vector. Both named colors and hexadecimal color codes are allowed. The function has 8 colors stored internally.
If \code{module_colors} = NULL (default), these colors are used. If the model has more than 8 modules, \code{module_colors} must be specified. If more
colors than necessary are specified, the function takes as many as necessary from the start of the vector.}

\item{render}{For \code{plot.epicmodel_steplist_checked}, if TRUE (default), graph is directly rendered. IF FALSE, the output contains the
non-rendered graph.}
}
\value{
\itemize{
\item \code{new_steplist()}: An object of class \code{epicmodel_steplist}.
\item \code{validate_steplist()}: An object of class \code{epicmodel_steplist} or \code{epicmodel_steplist_checked}, that has been checked to have the correct
structure.
\item \code{empty_steplist()}: An empty object of class \code{epicmodel_steplist} object with correct structure.
\item \code{print.epicmodel_steplist()}: Prints the number of entries in each data.frame in the console and the information that the steplist is
\code{unchecked}.
\item \code{print.epicmodel_steplist_checked()}: Same as \code{print.epicmodel_steplist()} but with the information the the steplist has been checked
successfully.
\item \code{summary.epicmodel_steplist()}: Prints an allert that the steplist needs to be checked with \code{check_steplist()} before using \code{summary()}.
\item \code{summary.epicmodel_steplist_checked()}: Prints a list of steps by type of step in the console.
\item \code{plot.epicmodel_steplist()}: Prints an allert that the steplist needs to be checked with \code{check_steplist()} before using \code{plot()}.
\item \code{plot.epicmodel_steplist_checked()}: Prints a graph of the complete network of mechanisms in the RStudio Viewer and the corresponding legend
in the console.
}
}
\description{
The S3 classes \code{epicmodel_steplist} and \code{epicmodel_steplist_checked} store the input information for SCC model creation. They are created from
the Steplist Creator \code{shiny} app, which can be launched with \code{\link[=launch_steplist_creator]{launch_steplist_creator()}}.

\code{new_steplist()}, \code{validate_steplist()}, and \code{empty_steplist()} define the S3 class.

\code{print()} prints a summary of the steplist entries in the console.

\code{summary()} prints a list of steps sorted by type of step in the console.

\code{plot()} renders a graph of the complete network of mechanisms in the RStudio Viewer.
}
\details{
\subsection{\code{epicmodel_steplist} objects}{

\code{epicmodel_steplist} objects are lists containing 8 data.frames. These data.frames are described below:
\describe{
\item{\code{what}}{A list of subjects and objects (WHAT segments) appearing in the step descriptions, e.g., cells, interleukins, symptoms, etc.,
with the following variables:
\itemize{
\item id_what: Automatically created ID for WHAT segments. Starts with "a" followed by a number, e.g., a1. Used in creating automatic step IDs.
\item key_what: Keyword describing the WHAT segment. Used in steplist_creator shiny app dropdown menus.
\item desc_what: Text used in step descripiton.
\item plural_what: Indicates if plural (1) or singular (0) version of the DOES description should be used, if this WHAT segment is used as subject,
i.e., WHAT segment before the DOES segment.}
}

\item{\code{does}}{A list of actions or verbs (DOES segments), with which the WHAT segments interact, e.g., is present, produce, migrate,
exposed to, with the following variables:
\itemize{
\item id_does: Automatically created ID for DOES segments. Starts with "d" followed by a number, e.g., d1. Used in creating automatic step IDs.
\item key_does: Keyword describing the DOES segment. Used in steplist_creator shiny app dropdown menus.
\item subject_singular_does: Description used if subject (WHAT segment in front) has been specified as singular (plural_what=0).
\item subject_plural_does: Description used if subject (WHAT segment in front) has been specified as plural (plural_what=1).
\item no_subject_does: Description used if no subject (WHAT segment in front) has been specified.
\item then_object_does: Indicates if the object for this DOES segment is a WHAT segment (0) or a THEN statement (1).}
}

\item{\code{where}}{A list of locations (WHERE segments), where the specified actions take place, e.g., in the airways, with the following
variables:
\itemize{
\item id_where: Automatically created ID for WHERE segments. Starts with "e" followed by a number, e.g., e1. Used in creating automatic step IDs.
\item key_where: Keyword describing the WHERE segment. Used in steplist_creator shiny app dropdown menus.
\item desc_where: Text used in step descripiton. Please include the corresponding preposition, e.g., 'in', 'into', 'on', etc.}
}

\item{\code{then}}{A list of combinations of WHAT, DOES and WHERE segments (THEN statements). A THEN statement can contain up to 4 segments: WHAT
(subject), DOES, WHAT (object), WHERE. Not all 4 of them need to be specified. For some DOES segments, the corresponding object is not a WHAT
segment but a THEN statement (see \code{then_object_does}). In general, all combinations are possible, although only DOES, only WHERE, and WHAT WHAT
do not make a lot of sense. \code{then} exists to store the THEN statements that are later used in IF and IFNOT conditions. It contains the following
variables:
\itemize{
\item id_then: Automatically created ID based on segment IDs, e.g., a4, a1d5a15e9, d2a3.
\item desc_then: Automatically created description based on segment descriptions.}
}

\item{\code{module}}{Modules are groups, into which the steps are sorted, e.g., immune system, lung, etc., as it is sometimes of interest to see
which groups are involved in the sufficient causes. It contains the following variables:
\itemize{
\item id_module: Automatically created ID for modules. Starts with "m" followed by a number, e.g., m1.
\item key_module: Keyword describing the module.
\item desc_module: Module description.}
}

\item{\code{step}}{Main table of interest and the one further processed to create sufficient-component cause models. It contains the following
variables:
\itemize{
\item id_step: Automatically created step ID based on IDs of included THEN statements, e.g., IFd6a10IFNOTd6a18+d1a8THENa11d3a12.
\item desc_step: Automatically created step description based on descriptions of included THEN statements.
\item end_step: Indicator variable that describes if this step is at the end of a certain sub-mechanism, e.g., symptom x occured.
\item module_step: Module, i.e., group, into which this step has been sorted.
\item note_step: Additional notes that are important for future users, e.g., if there are conflicting results or if the result is from a mouse
model.
\item ref_step: References on which this step is based.}
}

\item{\code{icc}}{ICC is short for incompatibel component causes. It contains pairs of component causes, i.e., steps without IF or IFNOT condition,
that are not compatible with each other, i.e., cannot appear in the same sufficient cause. It contains the following variables:
\itemize{
\item id_icc: Automatically created ID for ICC pairs. Starts with "i" followed by a number, e.g., i1.
\item id1: Step ID of first component cause.
\item id2: Step ID of second component cause.
\item desc1: Step description of first component cause.
\item desc2: Step description of second component cause.}
}

\item{\code{outc}}{A list that contains conditions under which the outcome of interest is assumed to occur. Each line might contain one or more THEN
statements, that have been marked as end steps by setting step$end_step to 1. If more than one THEN statement is selected, they are combined
with AND logic. All lines in this table are combined with OR logic, i.e., any of the specified conditions is assumed to represent outcome
occurrence. The table contains the following variables:
\itemize{
\item id_outc: Automatically created ID for outcome definitions as a combination of the THEN statement IDs connected by '+'.
\item desc_outc: Automatically created description for the outcome definitions as a combination of the THEN statement descriptions.}
}
}
}

\subsection{\code{epicmodel_steplist_checked} objects}{

Before using \code{epicmodel_steplist} object for SCC model creation in \code{\link[=create_scc]{create_scc()}}, they need to be checked for any structures that might make
SCC model creation impossible. Checking is performed by \code{\link[=check_steplist]{check_steplist()}} and if successful, the returned object is of type
\code{epicmodel_steplist_checked}. When changing the steplist in the Steplist Creator \code{shiny} app or by functions \code{\link[=remove_all_modules]{remove_all_modules()}},
\code{\link[=remove_na]{remove_na()}}, or \code{\link[=remove_segment]{remove_segment()}}, the steplist is "un-checked" and returned as class \code{epicmodel_steplist}. Apart from that, both classes
have similar structure, which can be validated by \code{validate_steplist()}.
}
}
\examples{
# Create steplists in the Steplist Creator `shiny` app
if(interactive()){
launch_steplist_creator()
}

# Download the steplist from the `shiny` app
# Load the steplist into R
path <- system.file("extdata", "steplist_rain.rds", package = "epicmodel")
steplist <- readRDS(path)

# new_steplist(), validate_steplist(), and empty_steplist() are used in the `shiny` app
# nonetheless, you can check steplist structures with validate_steplist()
validate_steplist(steplist)

# print() provides a summary of steplist entries and if it's checked or unchecked
print(steplist)

# Check steplist before using `summary()` and `plot()`
steplist_checked <- check_steplist(steplist)
summary(steplist_checked)
plot(steplist_checked)
}
