% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{get_path}
\alias{get_path}
\title{Get Path Object from Environment}
\usage{
get_path(path, envir = getOption("envsetup.path.environment"))
}
\arguments{
\item{path}{An unquoted name of the path object to retrieve from the environment.}

\item{envir}{The environment to search for the path object. Defaults to the
value of \code{getOption("envsetup.path.environment")}.}
}
\value{
The path object stored in the specified environment under the given name.
}
\description{
Retrieves a path object from the specified environment using non-standard
evaluation. The function uses \code{substitute()} to capture the unevaluated
expression and \code{get()} to retrieve the corresponding object.
}
\examples{
# Create a custom environment and store some paths
path_env <- new.env()
assign("data_dir", "/home/user/data", envir = path_env)
assign("output_dir", "/home/user/output", envir = path_env)

# Set up the option to use our custom environment
options(envsetup.path.environment = path_env)

# Retrieve paths using the function
data_path <- get_path(data_dir)
output_path <- get_path(output_dir)

print(data_path)    # "/home/user/data"
print(output_path)  # "/home/user/output"

# Using with a different environment
temp_env <- new.env()
assign("temp_dir", "/tmp/analysis", envir = temp_env)
temp_path <- get_path(temp_dir, envir = temp_env)
print(temp_path)    # "/tmp/analysis"

}
\seealso{
\code{\link[base]{get}}, \code{\link[base]{substitute}}
}
