% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatisticalTests.R
\name{p_value_on_sampled}
\alias{p_value_on_sampled}
\title{Calculate p-value of sampled value}
\usage{
p_value_on_sampled(
  empirical_distribution,
  sampled_values,
  isFiltered = FALSE,
  includeZeroValue = FALSE
)
}
\arguments{
\item{empirical_distribution}{A numeric vector of values representing the empirical distribution (return value of DistributionAproximation function)}

\item{sampled_values}{A scalar or a vector of real valued number representing the sampled value (score to be tested)}

\item{isFiltered}{A boolean representing if we want to use the filtered distribution or the distribution as is (False by default)}

\item{includeZeroValue}{A boolean that indicate if you want to take into account the null score (False by default)}
}
\value{
A numeric value representing the empirical p-value
}
\description{
Calculate p-value of sampled value
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

cocktails = list(c(561, 904),
               c(1902, 4585))
               
estimated_score_distribution = DistributionApproximation(epochs = 10,
            ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy)
            
Hypergeom_of_cocktails = compute_hypergeom_on_list(cocktails = cocktails,
                              ATCtree = ATC_Tree_UpperBound_2024, 
                              observations = FAERS_myopathy)
            
p_value = p_value_on_sampled(empirical_distribution = estimated_score_distribution,
      sampled_values = Hypergeom_of_cocktails)
}
}
