// Generated by rstantools.  Do not edit by hand.

/*
    This file is part of rstanarm.
    Copyright (C) 2015, 2016 Trustees of Columbia University
    
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_simple_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 24> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 9, column 2 to column 30)",
  " (in 'string', line 10, column 2 to column 19)",
  " (in 'string', line 13, column 2 to column 24)",
  " (in 'string', line 14, column 2 to column 24)",
  " (in 'string', line 16, column 4 to column 28)",
  " (in 'string', line 17, column 4 to column 35)",
  " (in 'string', line 15, column 16 to line 18, column 5)",
  " (in 'string', line 15, column 2 to line 18, column 5)",
  " (in 'string', line 21, column 2 to column 23)",
  " (in 'string', line 22, column 2 to column 20)",
  " (in 'string', line 23, column 2 to column 31)",
  " (in 'string', line 24, column 2 to column 31)",
  " (in 'string', line 2, column 2 to column 8)",
  " (in 'string', line 3, column 8 to column 9)",
  " (in 'string', line 3, column 2 to column 25)",
  " (in 'string', line 4, column 8 to column 9)",
  " (in 'string', line 4, column 2 to column 25)",
  " (in 'string', line 5, column 8 to column 9)",
  " (in 'string', line 5, column 2 to column 21)",
  " (in 'string', line 6, column 8 to column 9)",
  " (in 'string', line 6, column 2 to column 22)",
  " (in 'string', line 13, column 8 to column 9)",
  " (in 'string', line 14, column 8 to column 9)"};
#include <stan_meta_header.hpp>
class model_simple final : public model_base_crtp<model_simple> {
private:
  int J;
  std::vector<int> ystararaw;
  std::vector<int> ystarbraw;
  std::vector<double> fpre;
  std::vector<double> fpost;
public:
  ~model_simple() {}
  model_simple(stan::io::var_context& context__, unsigned int
               random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_simple_namespace::model_simple";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 13;
      context__.validate_dims("data initialization", "J", "int",
        std::vector<size_t>{});
      J = std::numeric_limits<int>::min();
      current_statement__ = 13;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 14;
      stan::math::validate_non_negative_index("ystararaw", "J", J);
      current_statement__ = 15;
      context__.validate_dims("data initialization", "ystararaw", "int",
        std::vector<size_t>{static_cast<size_t>(J)});
      ystararaw = std::vector<int>(J, std::numeric_limits<int>::min());
      current_statement__ = 15;
      ystararaw = context__.vals_i("ystararaw");
      current_statement__ = 16;
      stan::math::validate_non_negative_index("ystarbraw", "J", J);
      current_statement__ = 17;
      context__.validate_dims("data initialization", "ystarbraw", "int",
        std::vector<size_t>{static_cast<size_t>(J)});
      ystarbraw = std::vector<int>(J, std::numeric_limits<int>::min());
      current_statement__ = 17;
      ystarbraw = context__.vals_i("ystarbraw");
      current_statement__ = 18;
      stan::math::validate_non_negative_index("fpre", "J", J);
      current_statement__ = 19;
      context__.validate_dims("data initialization", "fpre", "double",
        std::vector<size_t>{static_cast<size_t>(J)});
      fpre = std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 19;
      fpre = context__.vals_r("fpre");
      current_statement__ = 20;
      stan::math::validate_non_negative_index("fpost", "J", J);
      current_statement__ = 21;
      context__.validate_dims("data initialization", "fpost", "double",
        std::vector<size_t>{static_cast<size_t>(J)});
      fpost = std::vector<double>(J,
                std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 21;
      fpost = context__.vals_r("fpost");
      current_statement__ = 22;
      stan::math::validate_non_negative_index("lambdaa", "J", J);
      current_statement__ = 23;
      stan::math::validate_non_negative_index("lambdab", "J", J);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + 1;
  }
  inline std::string model_name() const final {
    return "model_simple";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_simple_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ delta = DUMMY_VAR__;
      current_statement__ = 1;
      delta = in__.template read_constrain_lub<local_scalar_t__,
                jacobian__>(0, 1, lp__);
      local_scalar_t__ mu = DUMMY_VAR__;
      current_statement__ = 2;
      mu = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
             lp__);
      std::vector<local_scalar_t__> lambdaa =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      std::vector<local_scalar_t__> lambdab =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      current_statement__ = 8;
      for (int i = 1; i <= J; ++i) {
        current_statement__ = 5;
        stan::model::assign(lambdab, (mu /
          stan::model::rvalue(fpre, "fpre", stan::model::index_uni(i))),
          "assigning variable lambdab", stan::model::index_uni(i));
        current_statement__ = 6;
        stan::model::assign(lambdaa, ((delta * mu) /
          stan::model::rvalue(fpost, "fpost", stan::model::index_uni(i))),
          "assigning variable lambdaa", stan::model::index_uni(i));
      }
      {
        current_statement__ = 9;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(mu, 1, 0.001));
        current_statement__ = 10;
        lp_accum__.add(stan::math::beta_lpdf<propto__>(delta, 1, 1));
        current_statement__ = 11;
        lp_accum__.add(stan::math::poisson_lpmf<propto__>(ystararaw, lambdaa));
        current_statement__ = 12;
        lp_accum__.add(stan::math::poisson_lpmf<propto__>(ystarbraw, lambdab));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_simple_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double delta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      delta = in__.template read_constrain_lub<local_scalar_t__,
                jacobian__>(0, 1, lp__);
      double mu = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      mu = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
             lp__);
      std::vector<double> lambdaa =
        std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      std::vector<double> lambdab =
        std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      out__.write(delta);
      out__.write(mu);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 8;
      for (int i = 1; i <= J; ++i) {
        current_statement__ = 5;
        stan::model::assign(lambdab, (mu /
          stan::model::rvalue(fpre, "fpre", stan::model::index_uni(i))),
          "assigning variable lambdab", stan::model::index_uni(i));
        current_statement__ = 6;
        stan::model::assign(lambdaa, ((delta * mu) /
          stan::model::rvalue(fpost, "fpost", stan::model::index_uni(i))),
          "assigning variable lambdaa", stan::model::index_uni(i));
      }
      if (emit_transformed_parameters__) {
        out__.write(lambdaa);
        out__.write(lambdab);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ delta = DUMMY_VAR__;
      current_statement__ = 1;
      delta = in__.read<local_scalar_t__>();
      out__.write_free_lub(0, 1, delta);
      local_scalar_t__ mu = DUMMY_VAR__;
      current_statement__ = 2;
      mu = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, mu);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "delta", "double",
        std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "mu", "double",
        std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ delta = DUMMY_VAR__;
      current_statement__ = 1;
      delta = context__.vals_r("delta")[(1 - 1)];
      out__.write_free_lub(0, 1, delta);
      local_scalar_t__ mu = DUMMY_VAR__;
      current_statement__ = 2;
      mu = context__.vals_r("mu")[(1 - 1)];
      out__.write_free_lb(0, mu);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"delta", "mu"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"lambdaa", "lambdab"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(J)},
             std::vector<size_t>{static_cast<size_t>(J)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "delta");
    param_names__.emplace_back(std::string() + "mu");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        param_names__.emplace_back(std::string() + "lambdaa" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        param_names__.emplace_back(std::string() + "lambdab" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "delta");
    param_names__.emplace_back(std::string() + "mu");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        param_names__.emplace_back(std::string() + "lambdaa" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        param_names__.emplace_back(std::string() + "lambdab" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"delta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambdaa\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"lambdab\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"delta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambdaa\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"lambdab\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (1 + 1);
    const size_t num_transformed = emit_transformed_parameters * ((J + J));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (1 + 1);
    const size_t num_transformed = emit_transformed_parameters * ((J + J));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_simple_namespace::model_simple;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_simple_namespace::profiles__;
}
#endif
#endif
