% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_dependence.R
\name{partial_dependence}
\alias{partial_dependence}
\alias{partial_dependence.default}
\alias{partial_dependence.ranger}
\alias{partial_dependence.explainer}
\alias{partial_dependence.H2OModel}
\title{Partial Dependence}
\usage{
partial_dependence(object, ...)

\method{partial_dependence}{default}(
  object,
  v,
  data,
  pred_fun = stats::predict,
  trafo = NULL,
  which_pred = NULL,
  w = NULL,
  breaks = "Sturges",
  right = TRUE,
  discrete_m = 13L,
  outlier_iqr = 2,
  pd_n = 500L,
  seed = NULL,
  ...
)

\method{partial_dependence}{ranger}(
  object,
  v,
  data,
  pred_fun = NULL,
  trafo = NULL,
  which_pred = NULL,
  w = NULL,
  breaks = "Sturges",
  right = TRUE,
  discrete_m = 13L,
  outlier_iqr = 2,
  pd_n = 500L,
  seed = NULL,
  ...
)

\method{partial_dependence}{explainer}(
  object,
  v = colnames(data),
  data = object$data,
  pred_fun = object$predict_function,
  trafo = NULL,
  which_pred = NULL,
  w = object$weights,
  breaks = "Sturges",
  right = TRUE,
  discrete_m = 13L,
  outlier_iqr = 2,
  pd_n = 500L,
  seed = NULL,
  ...
)

\method{partial_dependence}{H2OModel}(
  object,
  data,
  v = object@parameters$x,
  pred_fun = NULL,
  trafo = NULL,
  which_pred = NULL,
  w = object@parameters$weights_column$column_name,
  breaks = "Sturges",
  right = TRUE,
  discrete_m = 13L,
  outlier_iqr = 2,
  pd_n = 500L,
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{Fitted model.}

\item{...}{Further arguments passed to \code{pred_fun()}, e.g., \code{type = "response"} in
a \code{glm()} or (typically) \code{prob = TRUE} in classification models.}

\item{v}{Variable names to calculate statistics for.}

\item{data}{Matrix or data.frame.}

\item{pred_fun}{Prediction function, by default \code{stats::predict}.
The function takes three arguments (names irrelevant): \code{object}, \code{data}, and \code{...}.}

\item{trafo}{How should predictions be transformed?
A function or \code{NULL} (default). Examples are \code{log} (to switch to link scale)
or \code{exp} (to switch from link scale to the original scale).
Applied after \code{which_pred}.}

\item{which_pred}{If the predictions are multivariate: which column to pick
(integer or column name). By default \code{NULL} (picks last column). Applied before
\code{trafo}.}

\item{w}{Optional vector with case weights. Can also be a column name in \code{data}.
Having observations with non-positive weight is equivalent to excluding them.}

\item{breaks}{An integer, vector, or "Sturges" (the default) used to determine
bin breaks of continuous features. Values outside the total bin range are placed
in the outmost bins. To allow varying values of \code{breaks} across features,
\code{breaks} can be a list of the same length as \code{v}, or a \emph{named} list with breaks
for certain variables.}

\item{right}{Should bins be right-closed? The default is \code{TRUE}.
Vectorized over \code{v}. Only relevant for continuous features.}

\item{discrete_m}{Numeric features with up to this number of unique values should not
be binned but rather treated as discrete. The default is 13. Vectorized over \code{v}.}

\item{outlier_iqr}{If \code{breaks} is an integer or "Sturges", the breaks of a continuous
feature are calculated without taking into account feature values outside
quartiles +- \code{outlier_iqr} * IQR (where <= 9997 values are used to calculate the
quartiles). To let the breaks cover the full data range, set \code{outlier_iqr} to
0 or \code{Inf}. Vectorized over \code{v}.}

\item{pd_n}{Size of the data used for calculating partial dependence.
The default is 500. For larger \code{data} (and \code{w}), \code{pd_n} rows are randomly sampled.
Each variable specified by \code{v} uses the same sample.
Set to 0 to omit PD calculations.}

\item{seed}{Optional integer random seed used for:
\itemize{
\item \emph{Partial dependence:} select background data if \code{n > pd_n}.
\item \emph{Calculating breaks:} The bin range is determined without values outside
quartiles +- 2 IQR using a sample of <= 9997 observations to calculate quartiles.
}}
}
\value{
A list (of class "EffectData") with a data.frame per feature having columns:
\itemize{
\item \code{bin_mid}: Bin mid points. In the plots, the bars are centered around these.
\item \code{bin_width}: Absolute width of the bin. In the plots, these equal the bar widths.
\item \code{bin_mean}: For continuous features, the (possibly weighted) average feature
value within bin. For discrete features equivalent to \code{bin_mid}.
\item \code{N}: The number of observations within bin.
\item \code{weight}: The weight sum within bin. When \code{w = NULL}, equivalent to \code{N}.
\item Different statistics, depending on the function call.
}

Use single bracket subsetting to select part of the output. Note that each
data.frame contains an attribute "discrete" with the information whether the
feature is discrete or continuous. This attribute might be lost when you manually
modify the data.frames.
}
\description{
Calculates PD for one or multiple features.

PD was introduced by Friedman (2001) to study the (main) effects
of a ML model. PD of a model f and variable \code{X} at a certain value g
is derived by replacing the \code{X} values in a reference \code{data} by g,
and then calculating the average prediction of f over this modified data.
This is done for different g  to see how the average prediction of f changes in \code{X},
keeping all other feature values constant (Ceteris Paribus).

This function is a convenience wrapper around \code{\link[=feature_effects]{feature_effects()}}, which calls
the barebone implementation \code{\link[=.pd]{.pd()}} to calculate PD.
As grid points, it uses the arithmetic mean of \code{X} per bin (specified by \code{breaks}),
and eventually weighted by \code{w}.
}
\section{Methods (by class)}{
\itemize{
\item \code{partial_dependence(default)}: Default method.

\item \code{partial_dependence(ranger)}: Method for ranger models.

\item \code{partial_dependence(explainer)}: Method for DALEX explainers.

\item \code{partial_dependence(H2OModel)}: Method for H2O models.

}}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
M <- partial_dependence(fit, v = "Species", data = iris)
M |> plot()

M2 <- partial_dependence(fit, v = colnames(iris)[-1], data = iris)
plot(M2, share_y = "all")
}
\references{
Friedman, Jerome H. 2001, \emph{Greedy Function Approximation: A Gradient Boosting Machine.}
Annals of Statistics 29 (5): 1189-1232. doi:10.1214/aos/1013203451.
}
\seealso{
\code{\link[=feature_effects]{feature_effects()}}, \code{\link[=.pd]{.pd()}}, \code{\link[=ale]{ale()}}.
}
