% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ale.R
\name{.ale}
\alias{.ale}
\title{Barebone Accumulated Local Effects (ALE)}
\usage{
.ale(
  object,
  v,
  data,
  breaks,
  right = TRUE,
  pred_fun = stats::predict,
  trafo = NULL,
  which_pred = NULL,
  bin_size = 200L,
  w = NULL,
  g = NULL,
  ...
)
}
\arguments{
\item{object}{Fitted model.}

\item{v}{Variable name in \code{data} to calculate ALE.}

\item{data}{Matrix or data.frame.}

\item{breaks}{Bin breaks.}

\item{right}{Should bins be right-closed?
The default is \code{TRUE}. (No effect if \code{g} is provided.)}

\item{pred_fun}{Prediction function, by default \code{stats::predict}.
The function takes three arguments (names irrelevant): \code{object}, \code{data}, and \code{...}.}

\item{trafo}{How should predictions be transformed?
A function or \code{NULL} (default). Examples are \code{log} (to switch to link scale)
or \code{exp} (to switch from link scale to the original scale).
Applied after \code{which_pred}.}

\item{which_pred}{If the predictions are multivariate: which column to pick
(integer or column name). By default \code{NULL} (picks last column). Applied before
\code{trafo}.}

\item{bin_size}{Maximal number of observations used per bin. If there are more
observations in a bin, \code{bin_size} indices are randomly sampled. The default is 200.}

\item{w}{Optional vector with case weights.}

\item{g}{For internal use. The result of \code{as.factor(findInterval(...))}.
By default \code{NULL}.}

\item{...}{Further arguments passed to \code{pred_fun()}, e.g., \code{type = "response"} in
a \code{glm()} or (typically) \code{prob = TRUE} in classification models.}
}
\value{
Vector representing one ALE per bin.
}
\description{
This is a barebone implementation of Apley's ALE.
Per bin, the local effect \eqn{D_j} is calculated, and then accumulated over bins.
\eqn{D_j} equals the difference between the partial dependence at the
lower and upper bin breaks using only observations within bin.
To plot the values, we can make a line plot of the resulting vector against
upper bin breaks. Alternatively, the vector can be extended
from the left by the value 0, and then plotted against \emph{all} breaks.
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
v <- "Sepal.Width"
.ale(fit, v, data = iris, breaks = seq(2, 4, length.out = 5))
}
\references{
Apley, Daniel W., and Jingyu Zhu. 2020. \emph{Visualizing the Effects of Predictor Variables in Black Box Supervised Learning Models.}
Journal of the Royal Statistical Society Series B: Statistical Methodology,
82 (4): 1059–1086. doi:10.1111/rssb.12377.
}
\seealso{
\code{\link[=partial_dependence]{partial_dependence()}}
}
