% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow_tnss.R
\name{tnss_dummies}
\alias{tnss_dummies}
\title{Sample points for triangulated networks}
\usage{
tnss_dummies(
  xy,
  root,
  circ = TRUE,
  line = TRUE,
  diag = TRUE,
  grid = FALSE,
  rand = FALSE,
  ncirc = 9,
  rcirc = 2,
  nline = 10,
  ndiag = 50,
  ngrid = 50,
  nrand = 50
)
}
\arguments{
\item{xy}{coordinates of "real" nodes}

\item{root}{root node id}

\item{circ}{logical. create circular dummy nodes around leafs.}

\item{line}{logical. create dummy nodes on a straight line between root and leafs.}

\item{diag}{logical. create dummy nodes diagonally through space.}

\item{grid}{logical. create dummy nodes on a grid.}

\item{rand}{logical. create random dummy nodes.}

\item{ncirc}{numeric. number of circular dummy nodes per leaf.}

\item{rcirc}{numeric. radius of circles around leaf nodes.}

\item{nline}{numeric. number of straight line nodes per leaf.}

\item{ndiag}{numeric. number of dummy nodes on diagonals.}

\item{ngrid}{numeric. number of dummy nodes per dim on grid.}

\item{nrand}{numeric. number of random nodes to create.}
}
\value{
coordinates of dummy nodes
}
\description{
uses various sampling strategies to create dummy nodes for the \link{tnss_tree}
}
\examples{
# dummy nodes for tree rooted in California
xy <- cbind(state.center$x, state.center$y)
xy_dummy <- tnss_dummies(xy, 4)
}
\author{
David Schoch
}
