% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminators.R
\name{stoppingConditions}
\alias{stoppingConditions}
\alias{stopOnEvals}
\alias{stopOnIters}
\alias{stopOnOptY}
\alias{stopOnMaxTime}
\title{Stopping conditions}
\usage{
stopOnEvals(max.evals = NULL)

stopOnIters(max.iter = NULL)

stopOnOptY(opt.y, eps)

stopOnMaxTime(max.time = NULL)
}
\arguments{
\item{max.evals}{[\code{integer(1)}]\cr
Maximal number of function evaluations.
Default is \code{Inf}.}

\item{max.iter}{[\code{integer(1)}]\cr
Maximal number of iterations/generations.
Default is \code{Inf}.}

\item{opt.y}{[\code{numeric(1)}]\cr
Optimal scalar fitness function value.}

\item{eps}{[\code{numeric(1)}]\cr
Stop if absolute deviation from \code{opt.y} is lower than \code{eps}.}

\item{max.time}{[\code{integer(1)}]\cr
Time limit in seconds.
Default is \code{Inf}.}
}
\value{
[\code{ecr_terminator}]
}
\description{
Stop the EA after a fixed number of fitness function evaluations, after
a predefined number of generations/iterations, a given cutoff time or
if the known optimal function value is approximated (only for single-objective optimization).
}
\concept{stopping conditions}
