% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.mutator.gauss.R
\name{mutGauss}
\alias{mutGauss}
\title{Gaussian mutator.}
\usage{
mutGauss(ind, p = 1L, sdev = 0.05, lower, upper)
}
\arguments{
\item{ind}{[\code{numeric}]\cr
Numeric vector / individual to mutate.}

\item{p}{[\code{numeric(1)}]\cr
Probability of mutation for the gauss mutation operator.}

\item{sdev}{[\code{numeric(1)}\cr
Standard deviance of the Gauss mutation, i. e., the mutation strength.}

\item{lower}{[\code{numeric}]\cr
Vector of minimal values for each parameter of the decision space.}

\item{upper}{[\code{numeric}]\cr
Vector of maximal values for each parameter of the decision space.}
}
\value{
[\code{numeric}]
}
\description{
Default Gaussian mutation operator known from Evolutionary Algorithms.
This mutator is applicable only for \code{representation="float"}. Given
an individual \eqn{\mathbf{x} \in R^l} this mutator adds a Gaussian
distributed random value to each component of \eqn{\mathbf{x}}, i.~e.,
\eqn{\tilde{\mathbf{x}}_i = \mathbf{x}_i + \sigma \mathcal{N}(0, 1)}.
}
\references{
[1] Beyer, Hans-Georg & Schwefel, Hans-Paul (2002). Evolution strategies. 
Kluwer Academic Publishers.

[2] Mateo, P. M. & Alberto, I. (2011). A mutation operator based
on a Pareto ranking for multi-objective evolutionary algorithms. 
Springer Science+Business Meda. 57.
}
\seealso{
Other mutators: 
\code{\link{mutBitflip}()},
\code{\link{mutInsertion}()},
\code{\link{mutInversion}()},
\code{\link{mutJump}()},
\code{\link{mutPolynomial}()},
\code{\link{mutScramble}()},
\code{\link{mutSwap}()},
\code{\link{mutUniform}()}
}
\concept{mutators}
