% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prototype.R
\name{plot.eode}
\alias{plot.eode}
\title{Plot Phase Velocity Vector Field}
\usage{
\method{plot}{eode}(
  x,
  n.grid = 20,
  scaleL = 1,
  scaleAH = 1,
  scaleS = 1,
  set_covar = NULL,
  ...
)
}
\arguments{
\item{x}{The ODE system under consideration. An object of class "\code{eode}".}

\item{n.grid}{number of grids per dimension. A larger number indicates a smaller
grid size. Default 20.}

\item{scaleL}{scale factor of the arrow length.}

\item{scaleAH}{scale factor of the arrow head.}

\item{scaleS}{scale factor of the arrow size.}

\item{set_covar}{give certain values of model variables that are going to be fixed.}

\item{...}{ignored arguments}
}
\value{
a graphic object
}
\description{
Creates a plot of phase velocity vector (or its field) of an ODE system. With
two free variables the function creates a plot of the phase velocity vector field
within the range defined by model constraints. With a single free variable the
function creates a plot of one-dimensional phase velocity vector field. With
more than two variables the function will automatically set a value (the middle
of the lower and upper boundaries) for any extra variable to reduce axes. The
values can also be set using parameter "\code{set_covar}". If all model variables
have had their values, the function creates a plot to show the exact values of a
single phase velocity vector.
}
\examples{
## Example 1: Lotka-Volterra competition model
eq1 <- function(x, y, r1 = 4, a11 = 1, a12 = 2) (r1 - a11 * x - a12 * y) * x
eq2 <- function(x, y, r2 = 1, a21 = 2, a22 = 1) (r2 - a21 * x - a22 * y) * y
x <- eode(dxdt = eq1, dydt = eq2)
plot(x)

## Example 2: Susceptible-infected model
dX_Cdt <- function(X_C, Y_C, X_A, Y_A, nu = 0.15, beta = 0.1, mu = 0.15, g = 0.04) {
  nu * (X_A + Y_A) - beta * X_C * (Y_C + Y_A) - (mu + g) * X_C
}

dY_Cdt <- function(X_C, Y_C, Y_A, beta = 0.1, mu = 0.15, g = 0.04, rho = 0.2) {
  beta * X_C * (Y_C + Y_A) - (mu + g + rho) * Y_C
}

dX_Adt <- function(X_C, Y_C, X_A, Y_A, beta = 0.1, g = 0.04) {
  g * X_C - beta * X_A * (Y_C + Y_A)
}

dY_Adt <- function(X_A, Y_C, Y_A, beta = 0.1, g = 0.04, rho = 0.2) {
  beta * X_A * (Y_C + Y_A) + g * Y_C - rho * Y_A
}

x <- eode(
  dX_Cdt = dX_Cdt, dY_Cdt = dY_Cdt, dX_Adt = dX_Adt, dY_Adt = dY_Adt,
  constraint = c("X_C>=0", "Y_C>=0", "X_A>=0", "Y_A>=0")
)
plot(x)
plot(x, set_covar = list(X_A = 60, Y_A = 80))
plot(x, set_covar = list(Y_C = 80, X_A = 60, Y_A = 80))
plot(x, set_covar = list(X_C = 60, Y_C = 80, X_A = 60, Y_A = 80))

}
