% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prototype.R
\name{length.pdata}
\alias{length.pdata}
\title{Get Length Of Population Dynamics Data}
\usage{
\method{length}{pdata}(x, ...)
}
\arguments{
\item{x}{Object of class "\code{pdata}".}

\item{...}{Ignored.}
}
\value{
A scalar.
}
\description{
Get the number of observations of population dynamics data.
}
\examples{
eq1 <- function(x, y, r1 = 4, a11 = 1, a12 = 2) (r1 - a11 * x - a12 * y) * x
eq2 <- function(x, y, r2 = 1, a21 = 2, a22 = 1) (r2 - a21 * x - a22 * y) * y
x <- eode(dxdt = eq1, dydt = eq2)
pdata(x,
  init = data.frame(x = c(10, 20), y = c(5, 15)),
  t = c(3, 3),
  lambda = data.frame(z = c(15, 30)),
  formula = "z = x + y"
)
}
