% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{vd_LL_vdm_screen}
\alias{vd_LL_vdm_screen}
\title{Log-Likelihood for conjunctive-screening volumetric demand model}
\usage{
vd_LL_vdm_screen(draw, vd, fromdraw = 1)
}
\arguments{
\item{draw}{A list, 'echoice2' draws object}

\item{vd}{A tibble, tidy choice data (before dummy-coding)}

\item{fromdraw}{An integer, from which draw onwards to compute LL (i.e., excl. burnin)}
}
\value{
N x Draws Matrix of log-Likelihood values
}
\description{
Log-Likelihood for conjunctive-screening volumetric demand model
}
\examples{
data(icecream)
#fit model
icecream_est <- icecream \%>\% filter(id<20) \%>\% vd_est_vdm_screen(R=10, keep=1, cores=2)
#compute likelihood for each subject in each draw
loglls<-vd_LL_vdm_screen(icecream_est, icecream\%>\% filter(id<20), fromdraw = 2)
dim(loglls)
}
