% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tbl_duckdb.R
\name{read_tbl_duckdb}
\alias{read_tbl_duckdb}
\title{Read a table from a DuckDB database file}
\usage{
read_tbl_duckdb(
  path,
  table_name,
  ...,
  schema = "main",
  prudence = c("thrifty", "lavish", "stingy")
)
}
\arguments{
\item{path}{Path to the DuckDB database file.}

\item{table_name}{The name of the table to read.}

\item{...}{These dots are for future extensions and must be empty.}

\item{schema}{The schema name where the table is located. Defaults to \code{"main"}.}

\item{prudence}{Memory protection, controls if DuckDB may convert
intermediate results in DuckDB-managed memory to data frames in R memory.
\itemize{
\item \code{"thrifty"}: up to a maximum size of 1 million cells,
\item \code{"lavish"}: regardless of size,
\item \code{"stingy"}: never.
}

The default is \code{"thrifty"} for the ingestion functions,
and may be different for other functions.
See \code{vignette("prudence")} for more information.}
}
\value{
A duckplyr frame, see \code{\link[=as_duckdb_tibble]{as_duckdb_tibble()}} for details.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{read_tbl_duckdb()} reads a table from a DuckDB database file
by attaching the database file and reading the specified table.

The database file is attached to the default duckplyr connection
and remains attached for the duration of the R session
to support lazy evaluation.
}
\examples{
\dontshow{if (rlang::is_interactive()) withAutoprint(\{ # examplesIf}
# Create a temporary DuckDB database with a table
db_path <- tempfile(fileext = ".duckdb")
con <- DBI::dbConnect(duckdb::duckdb(), db_path)
DBI::dbWriteTable(con, "test_table", data.frame(a = 1:3, b = c("x", "y", "z")))
DBI::dbDisconnect(con)

# Read the table from the database file
df <- read_tbl_duckdb(db_path, "test_table")
print(df)

# Clean up
unlink(db_path)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=read_sql_duckdb]{read_sql_duckdb()}}, \code{\link[=db_exec]{db_exec()}}
}
