# Generated by 02-duckplyr_df-methods.R
#' @rdname semi_join.duckplyr_df
#' @export
semi_join.duckplyr_df <- function(x, y, by = NULL, copy = FALSE, ..., na_matches = c("na", "never")) {
  check_dots_empty0(...)
  error_call <- caller_env()
  y <- auto_copy(x, y, copy = copy)

  # https://github.com/duckdb/duckdb/issues/6597
  na_matches <- check_na_matches(na_matches, error_call = error_call)

  # Our implementation
  duckplyr_error <- rel_try(list(name = "semi_join", x = x, y = y, args = try_list(by = if (!is.null(by) && !is_cross_by(by)) as_join_by(by), copy = copy, na_matches = na_matches)),
    "No restrictions" = FALSE,
    {
      out <- rel_join_impl(x, y, by, "semi", na_matches, error_call = error_call)
      return(out)
    }
  )

  # dplyr forward
  check_prudence(x, duckplyr_error)

  semi_join <- dplyr$semi_join.data.frame
  out <- semi_join(x, y, by, copy = FALSE, ..., na_matches = na_matches)
  return(out)

  # dplyr implementation
  check_dots_empty0(...)
  y <- auto_copy(x, y, copy = copy)
  join_filter(
    x,
    y,
    by = by,
    type = "semi",
    na_matches = na_matches,
    user_env = caller_env()
  )
}

duckplyr_semi_join <- function(x, y, ...) {
  try_fetch(
    {
      x <- as_duckplyr_df_impl(x)
      y <- as_duckplyr_df_impl(y)
    },
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- semi_join(x, y, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
