% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_plot.R
\name{dtms_plot}
\alias{dtms_plot}
\title{Plotting transition probabilities}
\usage{
dtms_plot(
  probs,
  dtms,
  fromvar = "from",
  tovar = "to",
  timevar = "time",
  Pvar = "P",
  ...
)
}
\arguments{
\item{probs}{Object with transition probabilities as created with \code{dtms_transitions}.}

\item{dtms}{dtms object, as created with \code{dtms}.}

\item{fromvar}{Character (optional), name of variable in `probs` with starting state. Default is `from`.}

\item{tovar}{Character (optional), name of variable in `probs` with receiving state. Default is `to`.}

\item{timevar}{Character (optional), name of variable in `probs` with time scale. Default is `time`.}

\item{Pvar}{Character (optional), name of variable in `probs` with transition probabilities. Default is `P`.}

\item{...}{Further arguments passed to plot().}
}
\value{
No return value, called for side effects
}
\description{
A simple function for plotting transition probabilities with base R. This is
fast, but it is much easier to produce nicer looking results with
dtms_simplify.
}
\examples{
## Model setup
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
## Fit model
fit <- dtms_fit(data=estdata)
## Predict probabilities
probs    <- dtms_transitions(dtms=simple,
                             model = fit)
## Plot
dtms_plot(probs=probs,
          dtms=simple)
}
