% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-summary.R
\name{diagnose_nas}
\alias{diagnose_nas}
\title{Diagnose Missing Values}
\usage{
diagnose_nas(dt)
}
\arguments{
\item{dt}{A data.table to diagnose.}
}
\value{
An S3 object of class \code{diagnose_na} containing:
\describe{
\item{table}{A data.table with columns \code{variable}, \code{n_na}, \code{pct_na}, and
\code{n_valid}, sorted by \code{pct_na} descending.}
\item{n_cols}{Total number of columns in the input.}
\item{n_with_na}{Number of columns that have at least one NA.}
}
}
\description{
Reports NA counts and percentages for each column in a data.table,
sorted by missing percentage in descending order.
}
\examples{
library(data.table)
dt <- data.table(
  a = c(1, NA, 3),
  b = c(NA, NA, "x"),
  c = c(TRUE, FALSE, TRUE)
)
diagnose_nas(dt)

}
\seealso{
\code{\link[=get_summary_table]{get_summary_table()}} for comprehensive column summaries,
\code{\link[=diagnose_strings]{diagnose_strings()}} for string column quality
}
