% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topography.R
\name{arc}
\alias{arc}
\title{Average-Relative Curvature (ARC)}
\usage{
arc(mesh, range = c(0.01, 0.99))
}
\arguments{
\item{mesh}{object of class mesh3d}

\item{range}{a numeric vector of the form c('minrange', 'maxrange') indicating
the set limits for extreme values, beyond which arc values will be truncated.
If 'minrange' and 'maxrange' are comprised between 0 and 1, they are used as
arc percentages. If 'minrange' and 'maxrange' are not comprised between 0 and 1,
they are used as raw arc values}
}
\value{
A numeric vector of area-relative curvature values for all the polygons of the mesh.
}
\description{
Compute a scale-free estimate of mean curvature.
}
\details{
Area-relative curvature (ARC) is obtained by dividing the mean curvature of each triangle
by the mean curvature of an hemisphere, the surface area of which is the same as the surface area
of the total mesh object. Coincidentally, the surface area of a hemisphere is linked to
its mean curvature by the following function: 2.4481 * 1 / square root(surface area)
As a result, ARC is a scale-free estimate of surface curvature. It can
be used to estimate the sharpness of a mesh.
}
\examples{
curvature <- arc(dkmodel$complex)
summary(curvature)

#There is a default truncature of extreme values below 1\% or above 99\%.
#Without truncature:
curvature <- arc(dkmodel$complex, range = c(0, 1))
summary(curvature)

#mean positive ARC:
parc <- mean(curvature[curvature >= 0])
#mean negative ARC:
narc <- mean(curvature[curvature < 0])

#render on a map:
dkmap(dkmodel$complex, curvature, col = "arc",
min.range = -20, max.range = 20)
#absolute truncature of the values above 20 or below -20:
dkmap(dkmodel$complex, curvature, col = "arc", min.range = -20, max.range = 20)
}
