% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylProbPCA.R
\name{phylProbPCA}
\alias{phylProbPCA}
\title{Probabilistic Phylogenetic PCA}
\usage{
phylProbPCA(phy, x, ret_dim = 2, model = "BM", quiet = FALSE)
}
\arguments{
\item{phy}{phylogeny in "phylo" format.}

\item{x}{a matrix with traits in columns and species values in rows. Rownames must match the tip labels of phylogeny.}

\item{ret_dim}{number of dimensions (PC axes) to be kept by the model.}

\item{model}{choice of model of trait evolution. One of "BM", "lambda", "OU", or "EB".}

\item{quiet}{if function should suppress output to the console while running}
}
\value{
returns a list of class "phylPPCA". See "Details" for more information.
}
\description{
Function to perform probabilistic phylogenetic PCA. Allows for fit of alternative models of trait evolution using branch length transformation.
}
\details{
The function can be used to estimate the probabilistic phylogenetic PCA (3PCA) using distinct models of trait evolution. Models are implemented using branch length transformation. Model fitting happens in two steps. First the maximum likelihood of the evolutionary covariance matrix (R) and the parameter of the model is estimated. Then the 3PCA model is estimated using the phylogenetic tree with branch lengths transformed following the MLE for the parameter of each trait evolution model.

The function returns a list with the following elements. scores: the scores of the principal components; e_values: eigenvalues; e_vectors: eigenvectors or the projection; model_fit: information about the trait evolution model; loadings: the loadings of the PCs; varnames: the names of the variables; sig: the MLE of the error; mle.W: the MLE of the W matrix; Function also returns AIC, AICc, and BIC for the model.
}
\examples{
phy <- ratematrix::anoles$phy[[1]]
dt <- as.matrix( ratematrix::anoles$data[,1:3] )
ppca <- phylProbPCA(phy = phy, x = dt, ret_dim = 2)
doBiplot(x = ppca, add_margin = 0.3)

}
\references{
Revell, L. J. 2009. Size-Correction and Principal Components for Interspecific Comparative Studies. Evolution 63:3258–3268. doi: 10.1111/j.1558-5646.2009.00804.x

Revell, L. J. 2024. phytools 2.0: an updated R ecosystem for phylogenetic comparative methods (and other things). PeerJ 12:e16505. doi: 10.7717/peerj.16505

Tipping, M. E., and C. M. Bishop. 1999. Probabilistic Principal Component Analysis. Journal of the Royal Statistical Society Series B: Statistical Methodology 61(3):611–622. doi: 10.1111/1467-9868.00196
}
