% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbPCA.R
\name{ProbPCA}
\alias{ProbPCA}
\title{Probabilistic PCA}
\usage{
ProbPCA(x, ret_dim = 2)
}
\arguments{
\item{x}{a matrix with traits in columns and observations in rows.}

\item{ret_dim}{number of dimensions (PC axes) to be kept by the model.}
}
\value{
returns a list of class "phylPPCA". See "Details" for more information.
}
\description{
Function to perform (non-phylogenetic) probabilistic PCA. This function is a modification (fork) of Rdimtools::do.ppca .
}
\details{
This function uses the same algorithm as Rdimtools::do.ppca. However, it returns more details from the estimation and computes AIC and AICc.

The function returns a list with the following elements. scores: the scores of the principal components; projection: the eigenvectors; sig: the MLE of the error of the model; mle.W: the MLE of the W matrix: varnames: the names of the traits; loglik: the log-likelihood of the estimate. Function also returns AIC, AICc, and BIC for the model.
}
\examples{
dt <- as.matrix( ratematrix::anoles$data[,1:3] )
ppca <- ProbPCA(x = dt, ret_dim = 2)
doBiplot(x = ppca, add_margin = 0.3)

}
\references{
Tipping, M. E., and C. M. Bishop. 1999. Probabilistic Principal Component Analysis. Journal of the Royal Statistical Society Series B: Statistical Methodology 61(3):611–622. doi: 10.1111/1467-9868.00196
}
