% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discursive_size.R
\name{ntopics}
\alias{ntopics}
\title{Compute number of topics based on stm results}
\usage{
ntopics(x, docs, progress = TRUE)
}
\arguments{
\item{x}{A structural topic model estimated via \code{\link[stm:stm]{stm::stm()}}.}

\item{docs}{A set of documents used for the structural topic model; created via \code{\link[stm:prepDocuments]{stm::prepDocuments()}}.}

\item{progress}{Logical. Shows progress bar if TRUE.}
}
\value{
A numeric vector with the same length as the number of documents in \code{x} and \code{docs}.
}
\description{
This function takes a structural topic model output estimated via \code{\link[stm:stm]{stm::stm()}} as well as the underlying set of documents created via \code{\link[stm:prepDocuments]{stm::prepDocuments()}} to compute the relative number of topics raised in each open-ended response. The function returns a numeric vector of topic counts re-scaled to range from 0 to 1. See Kraft (2023) for details.
}
\examples{
\donttest{meta <- c("age", "educ_cont", "pid_cont", "educ_pid", "female")
openends <- c(paste0("oe0", 1:9), "oe10")
cces$resp <- apply(cces[, openends], 1, paste, collapse = " ")
cces <- cces[!apply(cces[, meta], 1, anyNA), ]
processed <- stm::textProcessor(cces$resp, metadata = cces[, meta])
out <- stm::prepDocuments(processed$documents, processed$vocab, processed$meta, lower.thresh = 10)
stm_fit <- stm::stm(out$documents, out$vocab, prevalence = as.matrix(out$meta), K=25, seed=12345)
ntopics(stm_fit, out)}
}
