% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{aggregate_terms}
\alias{aggregate_terms}
\title{Aggregate decomposition terms}
\usage{
aggregate_terms(
  x,
  aggregate_factors = TRUE,
  custom_aggregation = NULL,
  reweighting
)
}
\arguments{
\item{x}{an object of class "ob_decompose", usually , a result of a call to [ob_decompose()].}

\item{aggregate_factors}{boolean, if `TRUE` (default) terms associated with detailed factor
levels are aggregated to a single term for every factor variable.}

\item{custom_aggregation}{list specifying the aggregation of detailed decomposition
terms. The parameter `custom_aggregation` overrides the parameter `aggregate_factors`.
If `NULL` (default), then either all detailed terms or all terms associated with
a single variable are returned.}

\item{reweighting}{boolean, if `TRUE` the decompostion in `object` contains reweighting
(i.e. specification and reweighting error)}
}
\value{
The function returns an updated object of class "ob_decompose" containing
the aggregated decomposition terms.
}
\description{
The function aggregates decomposition terms and calculates
their covariance matrix based on detailed decomposition results.
}
