% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m2-methods.R
\name{fit_m2}
\alias{fit_m2}
\title{Model Fit M2 Calculations}
\usage{
fit_m2(model, ci = 0.9, ...)
}
\arguments{
\item{model}{An estimated diagnostic classification model.}

\item{ci}{The confidence interval for the RMSEA.}

\item{...}{Unused, for extensibility.}
}
\value{
A data frame containing:
\itemize{
\item \code{m2}: The M2 statistic
\item \code{df}: Degrees of freedom for the M2 statistic
\item \code{pval}: \emph{p}-value for the M2 statistic
\item \code{rmsea}: Root mean square error of approximation
\item \code{ci_lower}: Lower end of \code{ci} interval for RMSEA
\item \code{ci_upper}: Upper end of \code{ci} interval for RMSEA
\item \code{srmsr}: Standardized root mean square residual
}
}
\description{
Estimate the M2 statistic as described by Liu et al. (2016).
}
\examples{
possible_prof <- dcm2::as_binary(ncol(sample_data$q_matrix))

fit_dat <- sample_data$data \%>\%
             tidyr::pivot_wider(names_from = "item_id",
                                values_from = "score") \%>\%
             dplyr::select(-"resp_id") \%>\%
             as.matrix() \%>\%
             unname()
gdina_mod <- GDINA::GDINA(dat = fit_dat,
                          Q = data.frame(sample_data$q_matrix),
                          model = "logitGDINA",
                          control = list(conv.type = "neg2LL"))
fit_m2(gdina_mod, ci = 0.9)
}
\references{
Liu, Y., Tian, W., & Xin, T. (2016). An application of
\eqn{M_2}{M2} statistic to evaluate the fit of cognitive diagnostic
models. \emph{Journal of Educational and Behavioral Statistics, 41}, 3-26.
\doi{10.3102/1076998615621293}
}
