% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_col_as.R
\name{set_col_as_numeric}
\alias{set_col_as_numeric}
\title{Set columns as numeric}
\usage{
set_col_as_numeric(data_set, cols, strip_string = FALSE, verbose = TRUE)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{cols}{List of column(s) name(s) of data_set to transform into numerics}

\item{strip_string}{should I change "," to "." in the string? (logical, default to FALSE)
If set to TRUE, computation will be a bit longer}

\item{verbose}{Should the function log (logical, default to TRUE)}
}
\value{
data_set (as a \code{\link[data.table]{data.table}}), with specified columns set as numeric.
}
\description{
Set as numeric a character column (or a list of columns) from a data.table.
}
\examples{
# Build a fake data.table
data_set <- data.frame(charCol1 = c("1", "2", "3"),
						 charCol2 = c("4", "5", "6"))

# Set charCol1 and charCol2 as numeric
data_set <- set_col_as_numeric(data_set, cols = c("charCol1", "charCol2"))

# Using strip string when spaces or wrong decimal separator is used
data_set <- data.frame(charCol1 = c("1", "2", "3"),
                      charCol2 = c("4, 1", "5, 2", "6, 3"))

# Set charCol1 and charCol2 as numeric
set_col_as_numeric(data_set, cols = c("charCol1", "charCol2"))
# generate mistakes
set_col_as_numeric(data_set, cols = c("charCol1", "charCol2"), strip_string = TRUE)
# Doesn't generate any mistake (but is a bit slower)
}
